"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def report(
    hub, ctx, taskrunner_id: str, worker_group: str = None, hostname: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Task runners call ReportTaskRunnerHeartbeat every 15 minutes to indicate that they are operational. If the AWS Data Pipeline Task Runner is launched on a resource managed by AWS Data Pipeline, the web service can use this call to detect when the task runner application has failed and restart a new instance.

    Args:
        taskrunner_id(str): The ID of the task runner. This value should be unique across your AWS account. In the case of AWS Data Pipeline Task Runner launched on a resource managed by AWS Data Pipeline, the web service provides a unique identifier when it launches the application. If you have written a custom task runner, you should assign a unique identifier for the task runner.
        worker_group(str, optional): The type of task the task runner is configured to accept and process. The worker group is set as a field on objects in the pipeline when they are created. You can only specify a single value for workerGroup. There are no wildcard values permitted in workerGroup; the string must be an exact, case-sensitive, match. Defaults to None.
        hostname(str, optional): The public DNS name of the task runner. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.task.runner_heartbeat.report(
                ctx, taskrunner_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.task.runner_heartbeat.report taskrunner_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="report_task_runner_heartbeat",
        op_kwargs={
            "taskrunnerId": taskrunner_id,
            "workerGroup": worker_group,
            "hostname": hostname,
        },
    )
