"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def report(hub, ctx, task_id: str, fields: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Task runners call ReportTaskProgress when assigned a task to acknowledge that it has the task. If the web service does not receive this acknowledgement within 2 minutes, it assigns the task in a subsequent PollForTask call. After this initial acknowledgement, the task runner only needs to report progress every 15 minutes to maintain its ownership of the task. You can change this reporting time from 15 minutes by specifying a reportProgressTimeout field in your pipeline. If a task runner does not report its status after 5 minutes, AWS Data Pipeline assumes that the task runner is unable to process the task and reassigns the task in a subsequent response to PollForTask. Task runners should call ReportTaskProgress every 60 seconds.

    Args:
        task_id(str): The ID of the task assigned to the task runner. This value is provided in the response for PollForTask.
        fields(List, optional): Key-value pairs that define the properties of the ReportTaskProgressInput object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.task.progress.report(ctx, task_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.task.progress.report task_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="report_task_progress",
        op_kwargs={"taskId": task_id, "fields": fields},
    )
