"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, pipeline_id: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds or modifies tags for the specified pipeline.

    Args:
        pipeline_id(str): The ID of the pipeline.
        tags(List): The tags to add, as key/value pairs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.tags.add(ctx, pipeline_id=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.tags.add pipeline_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="add_tags",
        op_kwargs={"pipelineId": pipeline_id, "tags": tags},
    )


async def remove(hub, ctx, pipeline_id: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes existing tags from the specified pipeline.

    Args:
        pipeline_id(str): The ID of the pipeline.
        tag_keys(List): The keys of the tags to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.tags.remove(ctx, pipeline_id=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.tags.remove pipeline_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="remove_tags",
        op_kwargs={"pipelineId": pipeline_id, "tagKeys": tag_keys},
    )
