"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, pipeline_id: str, object_ids: List, status: str) -> None:
    r"""
    **Autogenerated function**

    Requests that the status of the specified physical or logical pipeline objects be updated in the specified pipeline. This update might not occur immediately, but is eventually consistent. The status that can be set depends on the type of object (for example, DataNode or Activity). You cannot perform this operation on FINISHED pipelines and attempting to do so returns InvalidRequestException.

    Args:
        pipeline_id(str): The ID of the pipeline that contains the objects.
        object_ids(List): The IDs of the objects. The corresponding objects can be either physical or components, but not a mix of both types.
        status(str): The status to be set on all the objects specified in objectIds. For components, use PAUSE or RESUME. For instances, use TRY_CANCEL, RERUN, or MARK_FINISHED.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.status.set(
                ctx, pipeline_id=value, object_ids=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.status.set pipeline_id=value, object_ids=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="set_status",
        op_kwargs={
            "pipelineId": pipeline_id,
            "objectIds": object_ids,
            "status": status,
        },
    )
