"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def activate(
    hub,
    ctx,
    pipeline_id: str,
    parameter_values: List = None,
    start_timestamp: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Validates the specified pipeline and starts processing pipeline tasks. If the pipeline does not pass validation, activation fails. If you need to pause the pipeline to investigate an issue with a component, such as a data source or script, call DeactivatePipeline. To activate a finished pipeline, modify the end date for the pipeline and then activate it.

    Args:
        pipeline_id(str): The ID of the pipeline.
        parameter_values(List, optional): A list of parameter values to pass to the pipeline at activation. Defaults to None.
        start_timestamp(str, optional): The date and time to resume the pipeline. By default, the pipeline resumes from the last completed execution. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.pipeline.init.activate(ctx, pipeline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.pipeline.init.activate pipeline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="activate_pipeline",
        op_kwargs={
            "pipelineId": pipeline_id,
            "parameterValues": parameter_values,
            "startTimestamp": start_timestamp,
        },
    )


async def create(
    hub, ctx, name: str, unique_id: str, description: str = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new, empty pipeline. Use PutPipelineDefinition to populate the pipeline.

    Args:
        name(str): The name for the pipeline. You can use the same name for multiple pipelines associated with your AWS account, because AWS Data Pipeline assigns each pipeline a unique pipeline identifier.
        unique_id(str): A unique identifier. This identifier is not the same as the pipeline identifier assigned by AWS Data Pipeline. You are responsible for defining the format and ensuring the uniqueness of this identifier. You use this parameter to ensure idempotency during repeated calls to CreatePipeline. For example, if the first call to CreatePipeline does not succeed, you can pass in the same unique identifier and pipeline name combination on a subsequent call to CreatePipeline. CreatePipeline ensures that if a pipeline already exists with the same name and unique identifier, a new pipeline is not created. Instead, you'll receive the pipeline identifier from the previous attempt. The uniqueness of the name and unique identifier combination is scoped to the AWS account or IAM user credentials.
        description(str, optional): The description for the pipeline. Defaults to None.
        tags(List, optional): A list of tags to associate with the pipeline at creation. Tags let you control access to pipelines. For more information, see Controlling User Access to Pipelines in the AWS Data Pipeline Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.pipeline.init.create(
                ctx, name=value, unique_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.pipeline.init.create name=value, unique_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="create_pipeline",
        op_kwargs={
            "name": name,
            "uniqueId": unique_id,
            "description": description,
            "tags": tags,
        },
    )


async def deactivate(hub, ctx, pipeline_id: str, cancel_active: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deactivates the specified running pipeline. The pipeline is set to the DEACTIVATING state until the deactivation process completes. To resume a deactivated pipeline, use ActivatePipeline. By default, the pipeline resumes from the last completed execution. Optionally, you can specify the date and time to resume the pipeline.

    Args:
        pipeline_id(str): The ID of the pipeline.
        cancel_active(bool, optional): Indicates whether to cancel any running objects. The default is true, which sets the state of any running objects to CANCELED. If this value is false, the pipeline is deactivated after all running objects finish. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.pipeline.init.deactivate(ctx, pipeline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.pipeline.init.deactivate pipeline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="deactivate_pipeline",
        op_kwargs={"pipelineId": pipeline_id, "cancelActive": cancel_active},
    )


async def delete(hub, ctx, pipeline_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a pipeline, its pipeline definition, and its run history. AWS Data Pipeline attempts to cancel instances associated with the pipeline that are currently being processed by task runners. Deleting a pipeline cannot be undone. You cannot query or restore a deleted pipeline. To temporarily pause a pipeline instead of deleting it, call SetStatus with the status set to PAUSE on individual components. Components that are paused by SetStatus can be resumed.

    Args:
        pipeline_id(str): The ID of the pipeline.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.pipeline.init.delete(ctx, pipeline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.pipeline.init.delete pipeline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="delete_pipeline",
        op_kwargs={"pipelineId": pipeline_id},
    )


async def describe_all(hub, ctx, pipeline_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves metadata about one or more pipelines. The information retrieved includes the name of the pipeline, the pipeline identifier, its current state, and the user account that owns the pipeline. Using account credentials, you can retrieve metadata about pipelines that you or your IAM users have created. If you are using an IAM user account, you can retrieve metadata about only those pipelines for which you have read permissions. To retrieve the full pipeline definition instead of metadata about the pipeline, call GetPipelineDefinition.

    Args:
        pipeline_ids(List): The IDs of the pipelines to describe. You can pass as many as 25 identifiers in a single call. To obtain pipeline IDs, call ListPipelines.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.pipeline.init.describe_all(ctx, pipeline_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.pipeline.init.describe_all pipeline_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="describe_pipelines",
        op_kwargs={"pipelineIds": pipeline_ids},
    )


async def list_all(hub, ctx, marker: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the pipeline identifiers for all active pipelines that you have permission to access.

    Args:
        marker(str, optional): The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call ListPipelines with the marker value from the previous call to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.pipeline.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.pipeline.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="list_pipelines",
        op_kwargs={"marker": marker},
    )
