"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, pipeline_id: str, version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the definition of the specified pipeline. You can call GetPipelineDefinition to retrieve the pipeline definition that you provided using PutPipelineDefinition.

    Args:
        pipeline_id(str): The ID of the pipeline.
        version(str, optional): The version of the pipeline definition to retrieve. Set this parameter to latest (default) to use the last definition saved to the pipeline or active to use the last definition that was activated. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.pipeline.definition.get(ctx, pipeline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.pipeline.definition.get pipeline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="get_pipeline_definition",
        op_kwargs={"pipelineId": pipeline_id, "version": version},
    )


async def put(
    hub,
    ctx,
    pipeline_id: str,
    pipeline_objects: List,
    parameter_objects: List = None,
    parameter_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds tasks, schedules, and preconditions to the specified pipeline. You can use PutPipelineDefinition to populate a new pipeline.  PutPipelineDefinition also validates the configuration as it adds it to the pipeline. Changes to the pipeline are saved unless one of the following three validation errors exists in the pipeline.   An object is missing a name or identifier field. A string or reference field is empty. The number of objects in the pipeline exceeds the maximum allowed objects. The pipeline is in a FINISHED state.   Pipeline object definitions are passed to the PutPipelineDefinition action and returned by the GetPipelineDefinition action.

    Args:
        pipeline_id(str): The ID of the pipeline.
        pipeline_objects(List): The objects that define the pipeline. These objects overwrite the existing pipeline definition.
        parameter_objects(List, optional): The parameter objects used with the pipeline. Defaults to None.
        parameter_values(List, optional): The parameter values used with the pipeline. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.pipeline.definition.put(
                ctx, pipeline_id=value, pipeline_objects=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.pipeline.definition.put pipeline_id=value, pipeline_objects=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="put_pipeline_definition",
        op_kwargs={
            "pipelineId": pipeline_id,
            "pipelineObjects": pipeline_objects,
            "parameterObjects": parameter_objects,
            "parameterValues": parameter_values,
        },
    )


async def validate(
    hub,
    ctx,
    pipeline_id: str,
    pipeline_objects: List,
    parameter_objects: List = None,
    parameter_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Validates the specified pipeline definition to ensure that it is well formed and can be run without error.

    Args:
        pipeline_id(str): The ID of the pipeline.
        pipeline_objects(List): The objects that define the pipeline changes to validate against the pipeline.
        parameter_objects(List, optional): The parameter objects used with the pipeline. Defaults to None.
        parameter_values(List, optional): The parameter values used with the pipeline. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.pipeline.definition.validate(
                ctx, pipeline_id=value, pipeline_objects=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.pipeline.definition.validate pipeline_id=value, pipeline_objects=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="validate_pipeline_definition",
        op_kwargs={
            "pipelineId": pipeline_id,
            "pipelineObjects": pipeline_objects,
            "parameterObjects": parameter_objects,
            "parameterValues": parameter_values,
        },
    )
