"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "object"


async def describe_all(
    hub,
    ctx,
    pipeline_id: str,
    object_ids: List,
    evaluate_expressions: bool = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the object definitions for a set of objects associated with the pipeline. Object definitions are composed of a set of fields that define the properties of the object.

    Args:
        pipeline_id(str): The ID of the pipeline that contains the object definitions.
        object_ids(List): The IDs of the pipeline objects that contain the definitions to be described. You can pass as many as 25 identifiers in a single call to DescribeObjects.
        evaluate_expressions(bool, optional): Indicates whether any expressions in the object should be evaluated when the object descriptions are returned. Defaults to None.
        marker(str, optional): The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call DescribeObjects with the marker value from the previous call to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.object_.describe_all(
                ctx, pipeline_id=value, object_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.object.describe_all pipeline_id=value, object_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="describe_objects",
        op_kwargs={
            "pipelineId": pipeline_id,
            "objectIds": object_ids,
            "evaluateExpressions": evaluate_expressions,
            "marker": marker,
        },
    )


async def query(
    hub,
    ctx,
    pipeline_id: str,
    sphere: str,
    query: Dict = None,
    marker: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Queries the specified pipeline for the names of objects that match the specified set of conditions.

    Args:
        pipeline_id(str): The ID of the pipeline.
        query(Dict, optional): The query that defines the objects to be returned. The Query object can contain a maximum of ten selectors. The conditions in the query are limited to top-level String fields in the object. These filters can be applied to components, instances, and attempts. Defaults to None.
        sphere(str): Indicates whether the query applies to components or instances. The possible values are: COMPONENT, INSTANCE, and ATTEMPT.
        marker(str, optional): The starting point for the results to be returned. For the first call, this value should be empty. As long as there are more results, continue to call QueryObjects with the marker value from the previous call to retrieve the next set of results. Defaults to None.
        limit(int, optional): The maximum number of object names that QueryObjects will return in a single call. The default value is 100. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.object_.query(ctx, pipeline_id=value, sphere=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.object.query pipeline_id=value, sphere=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="query_objects",
        op_kwargs={
            "pipelineId": pipeline_id,
            "query": query,
            "sphere": sphere,
            "marker": marker,
            "limit": limit,
        },
    )
