"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def evaluate(hub, ctx, pipeline_id: str, object_id: str, expression: str) -> Dict:
    r"""
    **Autogenerated function**

    Task runners call EvaluateExpression to evaluate a string in the context of the specified object. For example, a task runner can evaluate SQL queries stored in Amazon S3.

    Args:
        pipeline_id(str): The ID of the pipeline.
        object_id(str): The ID of the object.
        expression(str): The expression to evaluate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.datapipeline.expression.evaluate(
                ctx, pipeline_id=value, object_id=value, expression=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.datapipeline.expression.evaluate pipeline_id=value, object_id=value, expression=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="datapipeline",
        operation="evaluate_expression",
        op_kwargs={
            "pipelineId": pipeline_id,
            "objectId": object_id,
            "expression": expression,
        },
    )
