"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, data_set_id: str, comment: str = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    This operation creates a revision for a data set.

    Args:
        comment(str, optional): An optional comment about the revision. Defaults to None.
        data_set_id(str): The unique identifier for a data set.
        tags(Dict, optional): A revision tag is an optional label that you can assign to a revision when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.revision.init.create(ctx, data_set_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.revision.init.create data_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="create_revision",
        op_kwargs={"Comment": comment, "DataSetId": data_set_id, "Tags": tags},
    )


async def delete(hub, ctx, data_set_id: str, revision_id: str) -> None:
    r"""
    **Autogenerated function**

    This operation deletes a revision.

    Args:
        data_set_id(str): The unique identifier for a data set.
        revision_id(str): The unique identifier for a revision.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.revision.init.delete(
                ctx, data_set_id=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.revision.init.delete data_set_id=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="delete_revision",
        op_kwargs={"DataSetId": data_set_id, "RevisionId": revision_id},
    )


async def get(hub, ctx, data_set_id: str, revision_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns information about a revision.

    Args:
        data_set_id(str): The unique identifier for a data set.
        revision_id(str): The unique identifier for a revision.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.revision.init.get(
                ctx, data_set_id=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.revision.init.get data_set_id=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="get_revision",
        op_kwargs={"DataSetId": data_set_id, "RevisionId": revision_id},
    )


async def update(
    hub,
    ctx,
    data_set_id: str,
    revision_id: str,
    comment: str = None,
    finalized: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation updates a revision.

    Args:
        comment(str, optional): An optional comment about the revision. Defaults to None.
        data_set_id(str): The unique identifier for a data set.
        finalized(bool, optional): Finalizing a revision tells AWS Data Exchange that your changes to the assets in the revision are complete. After it's in this read-only state, you can publish the revision to your products. Defaults to None.
        revision_id(str): The unique identifier for a revision.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.revision.init.update(
                ctx, data_set_id=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.revision.init.update data_set_id=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="update_revision",
        op_kwargs={
            "Comment": comment,
            "DataSetId": data_set_id,
            "Finalized": finalized,
            "RevisionId": revision_id,
        },
    )
