"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    data_set_id: str,
    revision_id: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation lists a revision's assets sorted alphabetically in descending order.

    Args:
        data_set_id(str): The unique identifier for a data set.
        max_results(int, optional): The maximum number of results returned by a single call. Defaults to None.
        next_token(str, optional): The token value retrieved from a previous call to access the next page of results. Defaults to None.
        revision_id(str): The unique identifier for a revision.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.revision.asset.list_all(
                ctx, data_set_id=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.revision.asset.list_all data_set_id=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="list_revision_assets",
        op_kwargs={
            "DataSetId": data_set_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "RevisionId": revision_id,
        },
    )
