"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> None:
    r"""
    **Autogenerated function**

    This operation tags a resource.

    Args:
        resource_arn(str): An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
        tags(Dict): A label that consists of a customer-defined key and an optional value.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    This operation removes one or more tags from a resource.

    Args:
        resource_arn(str): An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
        tag_keys(List): The key tags.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.resource.untag(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
