"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    data_set_id: str = None,
    max_results: int = None,
    next_token: str = None,
    revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation lists your jobs sorted by CreatedAt in descending order.

    Args:
        data_set_id(str, optional): The unique identifier for a data set. Defaults to None.
        max_results(int, optional): The maximum number of results returned by a single call. Defaults to None.
        next_token(str, optional): The token value retrieved from a previous call to access the next page of results. Defaults to None.
        revision_id(str, optional): The unique identifier for a revision. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.jobs.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.jobs.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="list_jobs",
        op_kwargs={
            "DataSetId": data_set_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "RevisionId": revision_id,
        },
    )
