"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, job_id: str) -> None:
    r"""
    **Autogenerated function**

    This operation cancels a job. Jobs can be cancelled only when they are in the WAITING state.

    Args:
        job_id(str): The unique identifier for a job.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.job.cancel(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.job.cancel job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="cancel_job",
        op_kwargs={"JobId": job_id},
    )


async def create(hub, ctx, details: Dict, type_: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation creates a job.

    Args:
        details(Dict): The details for the CreateJob request.
        type_(str): The type of job to be created.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.job.create(ctx, details=value, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.job.create details=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="create_job",
        op_kwargs={"Details": details, "Type": type_},
    )


async def get(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns information about a job.

    Args:
        job_id(str): The unique identifier for a job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.job.get(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.job.get job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="get_job",
        op_kwargs={"JobId": job_id},
    )


async def start(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation starts a job.

    Args:
        job_id(str): The unique identifier for a job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.job.start(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.job.start job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="start_job",
        op_kwargs={"JobId": job_id},
    )
