"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, asset_type: str, description: str, name: str, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    This operation creates a data set.

    Args:
        asset_type(str): The type of file your data is stored in. Currently, the supported asset type is S3_SNAPSHOT.
        description(str): A description for the data set. This value can be up to 16,348 characters long.
        name(str): The name of the data set.
        tags(Dict, optional): A data set tag is an optional label that you can assign to a data set when you create it. Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to these data sets and revisions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.data_set_.init.create(
                ctx, asset_type=value, description=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.data_set_.init.create asset_type=value, description=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="create_data_set",
        op_kwargs={
            "AssetType": asset_type,
            "Description": description,
            "Name": name,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, data_set_id: str) -> None:
    r"""
    **Autogenerated function**

    This operation deletes a data set.

    Args:
        data_set_id(str): The unique identifier for a data set.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.data_set_.init.delete(ctx, data_set_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.data_set_.init.delete data_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="delete_data_set",
        op_kwargs={"DataSetId": data_set_id},
    )


async def get(hub, ctx, data_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns information about a data set.

    Args:
        data_set_id(str): The unique identifier for a data set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.data_set_.init.get(ctx, data_set_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.data_set_.init.get data_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="get_data_set",
        op_kwargs={"DataSetId": data_set_id},
    )


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, origin: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    This operation lists your data sets. When listing by origin OWNED, results are sorted by CreatedAt in descending order. When listing by origin ENTITLED, there is no order and the maxResults parameter is ignored.

    Args:
        max_results(int, optional): The maximum number of results returned by a single call. Defaults to None.
        next_token(str, optional): The token value retrieved from a previous call to access the next page of results. Defaults to None.
        origin(str, optional): A property that defines the data set as OWNED by the account (for providers) or ENTITLED to the account (for subscribers). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.data_set_.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.data_set_.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="list_data_sets",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "Origin": origin,
        },
    )


async def update(
    hub, ctx, data_set_id: str, description: str = None, name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    This operation updates a data set.

    Args:
        data_set_id(str): The unique identifier for a data set.
        description(str, optional): The description for the data set. Defaults to None.
        name(str, optional): The name of the data set. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.data_set_.init.update(ctx, data_set_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.data_set_.init.update data_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="update_data_set",
        op_kwargs={"DataSetId": data_set_id, "Description": description, "Name": name},
    )
