"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, asset_id: str, data_set_id: str, revision_id: str) -> None:
    r"""
    **Autogenerated function**

    This operation deletes an asset.

    Args:
        asset_id(str): The unique identifier for an asset.
        data_set_id(str): The unique identifier for a data set.
        revision_id(str): The unique identifier for a revision.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.asset.delete(
                ctx, asset_id=value, data_set_id=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.asset.delete asset_id=value, data_set_id=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="delete_asset",
        op_kwargs={
            "AssetId": asset_id,
            "DataSetId": data_set_id,
            "RevisionId": revision_id,
        },
    )


async def get(hub, ctx, asset_id: str, data_set_id: str, revision_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns information about an asset.

    Args:
        asset_id(str): The unique identifier for an asset.
        data_set_id(str): The unique identifier for a data set.
        revision_id(str): The unique identifier for a revision.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.asset.get(
                ctx, asset_id=value, data_set_id=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.asset.get asset_id=value, data_set_id=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="get_asset",
        op_kwargs={
            "AssetId": asset_id,
            "DataSetId": data_set_id,
            "RevisionId": revision_id,
        },
    )


async def update(
    hub, ctx, asset_id: str, data_set_id: str, name: str, revision_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    This operation updates an asset.

    Args:
        asset_id(str): The unique identifier for an asset.
        data_set_id(str): The unique identifier for a data set.
        name(str): The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name. When exporting to Amazon S3, the asset name is used as default target S3 object key.
        revision_id(str): The unique identifier for a revision.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.dataexchange.asset.update(
                ctx, asset_id=value, data_set_id=value, name=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.dataexchange.asset.update asset_id=value, data_set_id=value, name=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="dataexchange",
        operation="update_asset",
        op_kwargs={
            "AssetId": asset_id,
            "DataSetId": data_set_id,
            "Name": name,
            "RevisionId": revision_id,
        },
    )
