"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, cron_expression: str, name: str, job_names: List = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new schedule for one or more DataBrew jobs. Jobs can be run at a specific date and time, or at regular intervals.

    Args:
        job_names(List, optional): The name or names of one or more jobs to be run. Defaults to None.
        cron_expression(str): The date or dates and time or times when the jobs are to be run. For more information, see Cron expressions in the Glue DataBrew Developer Guide.
        tags(Dict, optional): Metadata tags to apply to this schedule. Defaults to None.
        name(str): A unique name for the schedule. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.schedule.create(ctx, cron_expression=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.schedule.create cron_expression=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="create_schedule",
        op_kwargs={
            "JobNames": job_names,
            "CronExpression": cron_expression,
            "Tags": tags,
            "Name": name,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified DataBrew schedule.

    Args:
        name(str): The name of the schedule to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.schedule.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.schedule.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="delete_schedule",
        op_kwargs={"Name": name},
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the definition of a specific DataBrew schedule.

    Args:
        name(str): The name of the schedule to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.schedule.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.schedule.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="describe_schedule",
        op_kwargs={"Name": name},
    )


async def list_all(
    hub, ctx, job_name: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the DataBrew schedules that are defined.

    Args:
        job_name(str, optional): The name of the job that these schedules apply to. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this request. . Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.schedule.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.schedule.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="list_schedules",
        op_kwargs={
            "JobName": job_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub, ctx, cron_expression: str, name: str, job_names: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the definition of an existing DataBrew schedule.

    Args:
        job_names(List, optional): The name or names of one or more jobs to be run for this schedule. Defaults to None.
        cron_expression(str): The date or dates and time or times when the jobs are to be run. For more information, see Cron expressions in the Glue DataBrew Developer Guide.
        name(str): The name of the schedule to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.schedule.update(ctx, cron_expression=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.schedule.update cron_expression=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="update_schedule",
        op_kwargs={
            "JobNames": job_names,
            "CronExpression": cron_expression,
            "Name": name,
        },
    )
