"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    role_arn: str,
    dataset_name: str = None,
    encryption_key_arn: str = None,
    encryption_mode: str = None,
    log_subscription: str = None,
    max_capacity: int = None,
    max_retries: int = None,
    outputs: List = None,
    data_catalog_outputs: List = None,
    database_outputs: List = None,
    project_name: str = None,
    recipe_reference: Dict = None,
    tags: Dict = None,
    timeout: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new job to transform input data, using steps defined in an existing Glue DataBrew recipe

    Args:
        dataset_name(str, optional): The name of the dataset that this job processes. Defaults to None.
        encryption_key_arn(str, optional): The Amazon Resource Name (ARN) of an encryption key that is used to protect the job. Defaults to None.
        encryption_mode(str, optional): The encryption mode for the job, which can be one of the following:    SSE-KMS - Server-side encryption with keys managed by KMS.    SSE-S3 - Server-side encryption with keys managed by Amazon S3.  . Defaults to None.
        name(str): A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
        log_subscription(str, optional): Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run. Defaults to None.
        max_capacity(int, optional): The maximum number of nodes that DataBrew can consume when the job processes data. Defaults to None.
        max_retries(int, optional): The maximum number of times to retry the job after a job run fails. Defaults to None.
        outputs(List, optional): One or more artifacts that represent the output from running the job. Defaults to None.
        data_catalog_outputs(List, optional): One or more artifacts that represent the Glue Data Catalog output from running the job. Defaults to None.
        database_outputs(List, optional): Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write to. . Defaults to None.
        project_name(str, optional): Either the name of an existing project, or a combination of a recipe and a dataset to associate with the recipe. Defaults to None.
        recipe_reference(Dict, optional): Represents the name and version of a DataBrew recipe. Defaults to None.
        role_arn(str): The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
        tags(Dict, optional): Metadata tags to apply to this job. Defaults to None.
        timeout(int, optional): The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of TIMEOUT. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.recipe.job.create(ctx, name=value, role_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.recipe.job.create name=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="create_recipe_job",
        op_kwargs={
            "DatasetName": dataset_name,
            "EncryptionKeyArn": encryption_key_arn,
            "EncryptionMode": encryption_mode,
            "Name": name,
            "LogSubscription": log_subscription,
            "MaxCapacity": max_capacity,
            "MaxRetries": max_retries,
            "Outputs": outputs,
            "DataCatalogOutputs": data_catalog_outputs,
            "DatabaseOutputs": database_outputs,
            "ProjectName": project_name,
            "RecipeReference": recipe_reference,
            "RoleArn": role_arn,
            "Tags": tags,
            "Timeout": timeout,
        },
    )


async def update(
    hub,
    ctx,
    name: str,
    role_arn: str,
    encryption_key_arn: str = None,
    encryption_mode: str = None,
    log_subscription: str = None,
    max_capacity: int = None,
    max_retries: int = None,
    outputs: List = None,
    data_catalog_outputs: List = None,
    database_outputs: List = None,
    timeout: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the definition of an existing DataBrew recipe job.

    Args:
        encryption_key_arn(str, optional): The Amazon Resource Name (ARN) of an encryption key that is used to protect the job. Defaults to None.
        encryption_mode(str, optional): The encryption mode for the job, which can be one of the following:    SSE-KMS - Server-side encryption with keys managed by KMS.    SSE-S3 - Server-side encryption with keys managed by Amazon S3.  . Defaults to None.
        name(str): The name of the job to update.
        log_subscription(str, optional): Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run. Defaults to None.
        max_capacity(int, optional): The maximum number of nodes that DataBrew can consume when the job processes data. Defaults to None.
        max_retries(int, optional): The maximum number of times to retry the job after a job run fails. Defaults to None.
        outputs(List, optional): One or more artifacts that represent the output from running the job. . Defaults to None.
        data_catalog_outputs(List, optional): One or more artifacts that represent the Glue Data Catalog output from running the job. Defaults to None.
        database_outputs(List, optional): Represents a list of JDBC database output objects which defines the output destination for a DataBrew recipe job to write into. Defaults to None.
        role_arn(str): The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
        timeout(int, optional): The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of TIMEOUT. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.recipe.job.update(ctx, name=value, role_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.recipe.job.update name=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="update_recipe_job",
        op_kwargs={
            "EncryptionKeyArn": encryption_key_arn,
            "EncryptionMode": encryption_mode,
            "Name": name,
            "LogSubscription": log_subscription,
            "MaxCapacity": max_capacity,
            "MaxRetries": max_retries,
            "Outputs": outputs,
            "DataCatalogOutputs": data_catalog_outputs,
            "DatabaseOutputs": database_outputs,
            "RoleArn": role_arn,
            "Timeout": timeout,
        },
    )
