"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, steps: List, description: str = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new DataBrew recipe.

    Args:
        description(str, optional): A description for the recipe. Defaults to None.
        name(str): A unique name for the recipe. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
        steps(List): An array containing the steps to be performed by the recipe. Each recipe step consists of one recipe action and (optionally) an array of condition expressions.
        tags(Dict, optional): Metadata tags to apply to this recipe. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.recipe.init.create(ctx, name=value, steps=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.recipe.init.create name=value, steps=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="create_recipe",
        op_kwargs={
            "Description": description,
            "Name": name,
            "Steps": steps,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, name: str, recipe_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the definition of a specific DataBrew recipe corresponding to a particular version.

    Args:
        name(str): The name of the recipe to be described.
        recipe_version(str, optional): The recipe version identifier. If this parameter isn't specified, then the latest published version is returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.recipe.init.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.recipe.init.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="describe_recipe",
        op_kwargs={"Name": name, "RecipeVersion": recipe_version},
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    recipe_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the DataBrew recipes that are defined.

    Args:
        max_results(int, optional): The maximum number of results to return in this request. . Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.
        recipe_version(str, optional): Return only those recipes with a version identifier of LATEST_WORKING or LATEST_PUBLISHED. If RecipeVersion is omitted, ListRecipes returns all of the LATEST_PUBLISHED recipe versions. Valid values: LATEST_WORKING | LATEST_PUBLISHED . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.recipe.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.recipe.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="list_recipes",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "RecipeVersion": recipe_version,
        },
    )


async def publish(hub, ctx, name: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Publishes a new version of a DataBrew recipe.

    Args:
        description(str, optional): A description of the recipe to be published, for this version of the recipe. Defaults to None.
        name(str): The name of the recipe to be published.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.recipe.init.publish(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.recipe.init.publish name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="publish_recipe",
        op_kwargs={"Description": description, "Name": name},
    )


async def update(
    hub, ctx, name: str, description: str = None, steps: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the definition of the LATEST_WORKING version of a DataBrew recipe.

    Args:
        description(str, optional): A description of the recipe. Defaults to None.
        name(str): The name of the recipe to be updated.
        steps(List, optional): One or more steps to be performed by the recipe. Each step consists of an action, and the conditions under which the action should succeed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.recipe.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.recipe.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="update_recipe",
        op_kwargs={"Description": description, "Name": name, "Steps": steps},
    )
