"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, name: str, assume_control: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an interactive session, enabling you to manipulate data in a DataBrew project.

    Args:
        name(str): The name of the project to act upon.
        assume_control(bool, optional): A value that, if true, enables you to take control of a session, even if a different client is currently accessing the project. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.project.session.init.start(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.project.session.init.start name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="start_project_session",
        op_kwargs={"Name": name, "AssumeControl": assume_control},
    )
