"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub,
    ctx,
    name: str,
    preview: bool = None,
    recipe_step: Dict = None,
    step_index: int = None,
    client_session_id: str = None,
    view_frame: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Performs a recipe step within an interactive DataBrew session that's currently open.

    Args:
        preview(bool, optional): If true, the result of the recipe step will be returned, but not applied. Defaults to None.
        name(str): The name of the project to apply the action to.
        recipe_step(Dict, optional): Represents a single step from a DataBrew recipe to be performed. Defaults to None.
        step_index(int, optional): The index from which to preview a step. This index is used to preview the result of steps that have already been applied, so that the resulting view frame is from earlier in the view frame stack. Defaults to None.
        client_session_id(str, optional): A unique identifier for an interactive session that's currently open and ready for work. The action will be performed on this session. Defaults to None.
        view_frame(Dict, optional): Represents the data being transformed during an action. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.project.session.action.send(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.project.session.action.send name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="send_project_session_action",
        op_kwargs={
            "Preview": preview,
            "Name": name,
            "RecipeStep": recipe_step,
            "StepIndex": step_index,
            "ClientSessionId": client_session_id,
            "ViewFrame": view_frame,
        },
    )
