"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    dataset_name: str,
    name: str,
    output_location: Dict,
    role_arn: str,
    encryption_key_arn: str = None,
    encryption_mode: str = None,
    log_subscription: str = None,
    max_capacity: int = None,
    max_retries: int = None,
    configuration: Dict = None,
    tags: Dict = None,
    timeout: int = None,
    job_sample: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new job to analyze a dataset and create its data profile.

    Args:
        dataset_name(str): The name of the dataset that this job is to act upon.
        encryption_key_arn(str, optional): The Amazon Resource Name (ARN) of an encryption key that is used to protect the job. Defaults to None.
        encryption_mode(str, optional): The encryption mode for the job, which can be one of the following:    SSE-KMS - SSE-KMS - Server-side encryption with KMS-managed keys.    SSE-S3 - Server-side encryption with keys managed by Amazon S3.  . Defaults to None.
        name(str): The name of the job to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
        log_subscription(str, optional): Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run. Defaults to None.
        max_capacity(int, optional): The maximum number of nodes that DataBrew can use when the job processes data. Defaults to None.
        max_retries(int, optional): The maximum number of times to retry the job after a job run fails. Defaults to None.
        output_location(Dict): Represents an Amazon S3 location (bucket name and object key) where DataBrew can read input data, or write output from a job.
        configuration(Dict, optional): Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings. Defaults to None.
        role_arn(str): The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
        tags(Dict, optional): Metadata tags to apply to this job. Defaults to None.
        timeout(int, optional): The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of TIMEOUT. Defaults to None.
        job_sample(Dict, optional): Sample configuration for profile jobs only. Determines the number of rows on which the profile job will be executed. If a JobSample value is not provided, the default value will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.profile_job.create(
                ctx, dataset_name=value, name=value, output_location=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.profile_job.create dataset_name=value, name=value, output_location=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="create_profile_job",
        op_kwargs={
            "DatasetName": dataset_name,
            "EncryptionKeyArn": encryption_key_arn,
            "EncryptionMode": encryption_mode,
            "Name": name,
            "LogSubscription": log_subscription,
            "MaxCapacity": max_capacity,
            "MaxRetries": max_retries,
            "OutputLocation": output_location,
            "Configuration": configuration,
            "RoleArn": role_arn,
            "Tags": tags,
            "Timeout": timeout,
            "JobSample": job_sample,
        },
    )


async def update(
    hub,
    ctx,
    name: str,
    output_location: Dict,
    role_arn: str,
    configuration: Dict = None,
    encryption_key_arn: str = None,
    encryption_mode: str = None,
    log_subscription: str = None,
    max_capacity: int = None,
    max_retries: int = None,
    timeout: int = None,
    job_sample: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the definition of an existing profile job.

    Args:
        configuration(Dict, optional): Configuration for profile jobs. Used to select columns, do evaluations, and override default parameters of evaluations. When configuration is null, the profile job will run with default settings. Defaults to None.
        encryption_key_arn(str, optional): The Amazon Resource Name (ARN) of an encryption key that is used to protect the job. Defaults to None.
        encryption_mode(str, optional): The encryption mode for the job, which can be one of the following:    SSE-KMS - Server-side encryption with keys managed by KMS.    SSE-S3 - Server-side encryption with keys managed by Amazon S3.  . Defaults to None.
        name(str): The name of the job to be updated.
        log_subscription(str, optional): Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log stream for each job run. Defaults to None.
        max_capacity(int, optional): The maximum number of compute nodes that DataBrew can use when the job processes data. Defaults to None.
        max_retries(int, optional): The maximum number of times to retry the job after a job run fails. Defaults to None.
        output_location(Dict): Represents an Amazon S3 location (bucket name and object key) where DataBrew can read input data, or write output from a job.
        role_arn(str): The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role to be assumed when DataBrew runs the job.
        timeout(int, optional): The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of TIMEOUT. Defaults to None.
        job_sample(Dict, optional): Sample configuration for Profile Jobs only. Determines the number of rows on which the Profile job will be executed. If a JobSample value is not provided for profile jobs, the default value will be used. The default value is CUSTOM_ROWS for the mode parameter and 20000 for the size parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.profile_job.update(
                ctx, name=value, output_location=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.profile_job.update name=value, output_location=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="update_profile_job",
        op_kwargs={
            "Configuration": configuration,
            "EncryptionKeyArn": encryption_key_arn,
            "EncryptionMode": encryption_mode,
            "Name": name,
            "LogSubscription": log_subscription,
            "MaxCapacity": max_capacity,
            "MaxRetries": max_retries,
            "OutputLocation": output_location,
            "RoleArn": role_arn,
            "Timeout": timeout,
            "JobSample": job_sample,
        },
    )
