"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    dataset_name: str = None,
    max_results: int = None,
    next_token: str = None,
    project_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the DataBrew jobs that are defined.

    Args:
        dataset_name(str, optional): The name of a dataset. Using this parameter indicates to return only those jobs that act on the specified dataset. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this request. . Defaults to None.
        next_token(str, optional): A token generated by DataBrew that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the NextToken value from the response object of the previous page call. . Defaults to None.
        project_name(str, optional): The name of a project. Using this parameter indicates to return only those jobs that are associated with the specified project. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.jobs.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.jobs.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="list_jobs",
        op_kwargs={
            "DatasetName": dataset_name,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ProjectName": project_name,
        },
    )
