"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, name: str, run_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Represents one run of a DataBrew job.

    Args:
        name(str): The name of the job being processed during this run.
        run_id(str): The unique identifier of the job run.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.job.run.describe(ctx, name=value, run_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.job.run.describe name=value, run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="describe_job_run",
        op_kwargs={"Name": name, "RunId": run_id},
    )


async def list_all(
    hub, ctx, name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the previous runs of a particular DataBrew job.

    Args:
        name(str): The name of the job.
        max_results(int, optional): The maximum number of results to return in this request. . Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.job.run.list_all(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.job.run.list_all name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="list_job_runs",
        op_kwargs={"Name": name, "MaxResults": max_results, "NextToken": next_token},
    )


async def start(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Runs a DataBrew job.

    Args:
        name(str): The name of the job to be run.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.job.run.start(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.job.run.start name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="start_job_run",
        op_kwargs={"Name": name},
    )


async def stop(hub, ctx, name: str, run_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a particular run of a job.

    Args:
        name(str): The name of the job to be stopped.
        run_id(str): The ID of the job run to be stopped.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.job.run.stop(ctx, name=value, run_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.job.run.stop name=value, run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="stop_job_run",
        op_kwargs={"Name": name, "RunId": run_id},
    )
