"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified DataBrew job.

    Args:
        name(str): The name of the job to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.job.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.job.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="databrew", operation="delete_job", op_kwargs={"Name": name}
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the definition of a specific DataBrew job.

    Args:
        name(str): The name of the job to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.job.init.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.job.init.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="databrew", operation="describe_job", op_kwargs={"Name": name}
    )
