"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, name: str, recipe_versions: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more versions of a recipe at a time. The entire request will be rejected if:   The recipe does not exist.   There is an invalid version identifier in the list of versions.   The version list is empty.   The version list size exceeds 50.   The version list contains duplicate entries.   The request will complete successfully, but with partial failures, if:   A version does not exist.   A version is being used by a job.   You specify LATEST_WORKING, but it's being used by a project.   The version fails to be deleted.   The LATEST_WORKING version will only be deleted if the recipe has no other versions. If you try to delete LATEST_WORKING while other versions exist (or if they can't be deleted), then LATEST_WORKING will be listed as partial failure in the response.

    Args:
        name(str): The name of the recipe whose versions are to be deleted.
        recipe_versions(List): An array of version identifiers, for the recipe versions to be deleted. You can specify numeric versions (X.Y) or LATEST_WORKING. LATEST_PUBLISHED is not supported.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.delete_recipe_version.batch(
                ctx, name=value, recipe_versions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.delete_recipe_version.batch name=value, recipe_versions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="batch_delete_recipe_version",
        op_kwargs={"Name": name, "RecipeVersions": recipe_versions},
    )
