"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    input_: Dict,
    format_: str = None,
    format_options: Dict = None,
    path_options: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new DataBrew dataset.

    Args:
        name(str): The name of the dataset to be created. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
        format_(str, optional): The file format of a dataset that is created from an Amazon S3 file or folder. Defaults to None.
        format_options(Dict, optional): Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input. Defaults to None.
        input_(Dict): Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.
        path_options(Dict, optional): A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset. Defaults to None.
        tags(Dict, optional): Metadata tags to apply to this dataset. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.dataset.create(ctx, name=value, input_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.dataset.create name=value, input_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="create_dataset",
        op_kwargs={
            "Name": name,
            "Format": format_,
            "FormatOptions": format_options,
            "Input": input_,
            "PathOptions": path_options,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a dataset from DataBrew.

    Args:
        name(str): The name of the dataset to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.dataset.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.dataset.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="delete_dataset",
        op_kwargs={"Name": name},
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the definition of a specific DataBrew dataset.

    Args:
        name(str): The name of the dataset to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.dataset.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.dataset.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="describe_dataset",
        op_kwargs={"Name": name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the DataBrew datasets.

    Args:
        max_results(int, optional): The maximum number of results to return in this request. . Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.dataset.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.dataset.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="list_datasets",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    name: str,
    input_: Dict,
    format_: str = None,
    format_options: Dict = None,
    path_options: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the definition of an existing DataBrew dataset.

    Args:
        name(str): The name of the dataset to be updated.
        format_(str, optional): The file format of a dataset that is created from an Amazon S3 file or folder. Defaults to None.
        format_options(Dict, optional): Represents a set of options that define the structure of either comma-separated value (CSV), Excel, or JSON input. Defaults to None.
        input_(Dict): Represents information on how DataBrew can find data, in either the Glue Data Catalog or Amazon S3.
        path_options(Dict, optional): A set of options that defines how DataBrew interprets an Amazon S3 path of the dataset. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.databrew.dataset.update(ctx, name=value, input_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.databrew.dataset.update name=value, input_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="databrew",
        operation="update_dataset",
        op_kwargs={
            "Name": name,
            "Format": format_,
            "FormatOptions": format_options,
            "Input": input_,
            "PathOptions": path_options,
        },
    )
