"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, domain_name: str, object_type_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the standard profile that were populated from this ProfileObjectType.

    Args:
        domain_name(str): The unique name of the domain.
        object_type_name(str): The name of the profile object type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.object_.type_.init.delete(
                ctx, domain_name=value, object_type_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.object_.type_.init.delete domain_name=value, object_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="delete_profile_object_type",
        op_kwargs={"DomainName": domain_name, "ObjectTypeName": object_type_name},
    )


async def get(hub, ctx, domain_name: str, object_type_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the object types for a specific domain.

    Args:
        domain_name(str): The unique name of the domain.
        object_type_name(str): The name of the profile object type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.object_.type_.init.get(
                ctx, domain_name=value, object_type_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.object_.type_.init.get domain_name=value, object_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="get_profile_object_type",
        op_kwargs={"DomainName": domain_name, "ObjectTypeName": object_type_name},
    )


async def list_all(
    hub, ctx, domain_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the templates available within the service.

    Args:
        domain_name(str): The unique name of the domain.
        next_token(str, optional): Identifies the next page of results to return. Defaults to None.
        max_results(int, optional): The maximum number of objects returned per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.object_.type_.init.list_all(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.object_.type_.init.list_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="list_profile_object_types",
        op_kwargs={
            "DomainName": domain_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def put(
    hub,
    ctx,
    domain_name: str,
    object_type_name: str,
    description: str,
    template_id: str = None,
    expiration_days: int = None,
    encryption_key: str = None,
    allow_profile_creation: bool = None,
    fields: Dict = None,
    keys: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Defines a ProfileObjectType.

    Args:
        domain_name(str): The unique name of the domain.
        object_type_name(str): The name of the profile object type.
        description(str): Description of the profile object type.
        template_id(str, optional): A unique identifier for the object template. Defaults to None.
        expiration_days(int, optional): The number of days until the data in the object expires. Defaults to None.
        encryption_key(str, optional): The customer-provided key to encrypt the profile object that will be created in this profile object type. Defaults to None.
        allow_profile_creation(bool, optional): Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is FALSE. If the AllowProfileCreation flag is set to FALSE, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to TRUE, and if no match is found, then the service creates a new standard profile. Defaults to None.
        fields(Dict, optional): A map of the name and ObjectType field. Defaults to None.
        keys(Dict, optional): A list of unique keys that can be used to map data to the profile. Defaults to None.
        tags(Dict, optional): The tags used to organize, track, or control access for this resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.object_.type_.init.put(
                ctx, domain_name=value, object_type_name=value, description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.object_.type_.init.put domain_name=value, object_type_name=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="put_profile_object_type",
        op_kwargs={
            "DomainName": domain_name,
            "ObjectTypeName": object_type_name,
            "Description": description,
            "TemplateId": template_id,
            "ExpirationDays": expiration_days,
            "EncryptionKey": encryption_key,
            "AllowProfileCreation": allow_profile_creation,
            "Fields": fields,
            "Keys": keys,
            "Tags": tags,
        },
    )
