"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub,
    ctx,
    profile_id: str,
    profile_object_unique_key: str,
    object_type_name: str,
    domain_name: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes an object associated with a profile of a given ProfileObjectType.

    Args:
        profile_id(str): The unique identifier of a customer profile.
        profile_object_unique_key(str): The unique identifier of the profile object generated by the service.
        object_type_name(str): The name of the profile object type.
        domain_name(str): The unique name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.object_.init.delete(
                ctx,
                profile_id=value,
                profile_object_unique_key=value,
                object_type_name=value,
                domain_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.object_.init.delete profile_id=value, profile_object_unique_key=value, object_type_name=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="delete_profile_object",
        op_kwargs={
            "ProfileId": profile_id,
            "ProfileObjectUniqueKey": profile_object_unique_key,
            "ObjectTypeName": object_type_name,
            "DomainName": domain_name,
        },
    )


async def list_all(
    hub,
    ctx,
    domain_name: str,
    object_type_name: str,
    profile_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of objects associated with a profile of a given ProfileObjectType.

    Args:
        next_token(str, optional): The pagination token from the previous call to ListProfileObjects. Defaults to None.
        max_results(int, optional): The maximum number of objects returned per page. Defaults to None.
        domain_name(str): The unique name of the domain.
        object_type_name(str): The name of the profile object type.
        profile_id(str): The unique identifier of a customer profile.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.object_.init.list_all(
                ctx, domain_name=value, object_type_name=value, profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.object_.init.list_all domain_name=value, object_type_name=value, profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="list_profile_objects",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "DomainName": domain_name,
            "ObjectTypeName": object_type_name,
            "ProfileId": profile_id,
        },
    )


async def put(hub, ctx, object_type_name: str, object_: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds additional objects to customer profiles of a given ObjectType. When adding a specific profile object, like a Contact Trace Record (CTR), an inferred profile can get created if it is not mapped to an existing profile. The resulting profile will only have a phone number populated in the standard ProfileObject. Any additional CTRs with the same phone number will be mapped to the same inferred profile. When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide data to a standard profile depending on the ProfileObjectType definition. PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.

    Args:
        object_type_name(str): The name of the profile object type.
        object_(str): A string that is serialized from a JSON object.
        domain_name(str): The unique name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.object_.init.put(
                ctx, object_type_name=value, object_=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.object_.init.put object_type_name=value, object_=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="put_profile_object",
        op_kwargs={
            "ObjectTypeName": object_type_name,
            "Object": object_,
            "DomainName": domain_name,
        },
    )
