"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(
    hub, ctx, profile_id: str, key_name: str, values: List, domain_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a new key value with a specific profile, such as a Contact Trace Record (CTR) ContactId. A profile object can have a single unique key and any number of additional keys that can be used to identify the profile that it belongs to.

    Args:
        profile_id(str): The unique identifier of a customer profile.
        key_name(str): A searchable identifier of a customer profile.
        values(List): A list of key values.
        domain_name(str): The unique name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.key.add(
                ctx, profile_id=value, key_name=value, values=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.key.add profile_id=value, key_name=value, values=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="add_profile_key",
        op_kwargs={
            "ProfileId": profile_id,
            "KeyName": key_name,
            "Values": values,
            "DomainName": domain_name,
        },
    )


async def delete(
    hub, ctx, profile_id: str, key_name: str, values: List, domain_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a searchable key from a customer profile.

    Args:
        profile_id(str): The unique identifier of a customer profile.
        key_name(str): A searchable identifier of a customer profile.
        values(List): A list of key values.
        domain_name(str): The unique name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.key.delete(
                ctx, profile_id=value, key_name=value, values=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.key.delete profile_id=value, key_name=value, values=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="delete_profile_key",
        op_kwargs={
            "ProfileId": profile_id,
            "KeyName": key_name,
            "Values": values,
            "DomainName": domain_name,
        },
    )
