"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    domain_name: str,
    account_number: str = None,
    additional_information: str = None,
    party_type: str = None,
    business_name: str = None,
    first_name: str = None,
    middle_name: str = None,
    last_name: str = None,
    birth_date: str = None,
    gender: str = None,
    phone_number: str = None,
    mobile_phone_number: str = None,
    home_phone_number: str = None,
    business_phone_number: str = None,
    email_address: str = None,
    personal_email_address: str = None,
    business_email_address: str = None,
    address: Dict = None,
    shipping_address: Dict = None,
    mailing_address: Dict = None,
    billing_address: Dict = None,
    attributes: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a standard profile. A standard profile represents the following attributes for a customer profile in a domain.

    Args:
        domain_name(str): The unique name of the domain.
        account_number(str, optional): A unique account number that you have given to the customer. Defaults to None.
        additional_information(str, optional): Any additional information relevant to the customer’s profile. Defaults to None.
        party_type(str, optional): The type of profile used to describe the customer. Defaults to None.
        business_name(str, optional): The name of the customer’s business. Defaults to None.
        first_name(str, optional): The customer’s first name. Defaults to None.
        middle_name(str, optional): The customer’s middle name. Defaults to None.
        last_name(str, optional): The customer’s last name. Defaults to None.
        birth_date(str, optional): The customer’s birth date. . Defaults to None.
        gender(str, optional): The gender with which the customer identifies. . Defaults to None.
        phone_number(str, optional): The customer’s phone number, which has not been specified as a mobile, home, or business number. . Defaults to None.
        mobile_phone_number(str, optional): The customer’s mobile phone number. Defaults to None.
        home_phone_number(str, optional): The customer’s home phone number. Defaults to None.
        business_phone_number(str, optional): The customer’s business phone number. Defaults to None.
        email_address(str, optional): The customer’s email address, which has not been specified as a personal or business address. . Defaults to None.
        personal_email_address(str, optional): The customer’s personal email address. Defaults to None.
        business_email_address(str, optional): The customer’s business email address. Defaults to None.
        address(Dict, optional): A generic address associated with the customer that is not mailing, shipping, or billing. Defaults to None.
        shipping_address(Dict, optional): The customer’s shipping address. Defaults to None.
        mailing_address(Dict, optional): The customer’s mailing address. Defaults to None.
        billing_address(Dict, optional): The customer’s billing address. Defaults to None.
        attributes(Dict, optional): A key value pair of attributes of a customer profile. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.init.create(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.init.create domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="create_profile",
        op_kwargs={
            "DomainName": domain_name,
            "AccountNumber": account_number,
            "AdditionalInformation": additional_information,
            "PartyType": party_type,
            "BusinessName": business_name,
            "FirstName": first_name,
            "MiddleName": middle_name,
            "LastName": last_name,
            "BirthDate": birth_date,
            "Gender": gender,
            "PhoneNumber": phone_number,
            "MobilePhoneNumber": mobile_phone_number,
            "HomePhoneNumber": home_phone_number,
            "BusinessPhoneNumber": business_phone_number,
            "EmailAddress": email_address,
            "PersonalEmailAddress": personal_email_address,
            "BusinessEmailAddress": business_email_address,
            "Address": address,
            "ShippingAddress": shipping_address,
            "MailingAddress": mailing_address,
            "BillingAddress": billing_address,
            "Attributes": attributes,
        },
    )


async def delete(hub, ctx, profile_id: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the standard customer profile and all data pertaining to the profile.

    Args:
        profile_id(str): The unique identifier of a customer profile.
        domain_name(str): The unique name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.init.delete(
                ctx, profile_id=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.init.delete profile_id=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="delete_profile",
        op_kwargs={"ProfileId": profile_id, "DomainName": domain_name},
    )


async def merge(
    hub,
    ctx,
    domain_name: str,
    main_profile_id: str,
    profile_ids_to_be_merged: List,
    field_source_profile_ids: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and subject to change. Runs an AWS Lambda job that does the following:   All the profileKeys in the ProfileToBeMerged will be moved to the main profile.   All the objects in the ProfileToBeMerged will be moved to the main profile.   All the ProfileToBeMerged will be deleted at the end.   All the profileKeys in the ProfileIdsToBeMerged will be moved to the main profile.   Standard fields are merged as follows:   Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.   When there are conflicting fields:   If no SourceProfileIds entry is specified, the main Profile value is always taken.    If a SourceProfileIds entry is specified, the specified profileId is always taken, even if it is a NULL value.       You can use MergeProfiles together with GetMatches, which returns potentially matching profiles, or use it with the results of another matching system. After profiles have been merged, they cannot be separated (unmerged).

    Args:
        domain_name(str): The unique name of the domain.
        main_profile_id(str): The identifier of the profile to be taken.
        profile_ids_to_be_merged(List): The identifier of the profile to be merged into MainProfileId.
        field_source_profile_ids(Dict, optional): The identifiers of the fields in the profile that has the information you want to apply to the merge. For example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of the EmailAddress field in Profile1. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.init.merge(
                ctx, domain_name=value, main_profile_id=value, profile_ids_to_be_merged=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.init.merge domain_name=value, main_profile_id=value, profile_ids_to_be_merged=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="merge_profiles",
        op_kwargs={
            "DomainName": domain_name,
            "MainProfileId": main_profile_id,
            "ProfileIdsToBeMerged": profile_ids_to_be_merged,
            "FieldSourceProfileIds": field_source_profile_ids,
        },
    )


async def search(
    hub,
    ctx,
    domain_name: str,
    key_name: str,
    values: List,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for profiles within a specific domain name using name, phone number, email address, account number, or a custom defined index.

    Args:
        next_token(str, optional): The pagination token from the previous SearchProfiles API call. Defaults to None.
        max_results(int, optional): The maximum number of objects returned per page. Defaults to None.
        domain_name(str): The unique name of the domain.
        key_name(str): A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _zendeskUserId, _zendeskExternalId, _serviceNowSystemId.
        values(List): A list of key values.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.init.search(
                ctx, domain_name=value, key_name=value, values=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.init.search domain_name=value, key_name=value, values=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="search_profiles",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "DomainName": domain_name,
            "KeyName": key_name,
            "Values": values,
        },
    )


async def update(
    hub,
    ctx,
    domain_name: str,
    profile_id: str,
    additional_information: str = None,
    account_number: str = None,
    party_type: str = None,
    business_name: str = None,
    first_name: str = None,
    middle_name: str = None,
    last_name: str = None,
    birth_date: str = None,
    gender: str = None,
    phone_number: str = None,
    mobile_phone_number: str = None,
    home_phone_number: str = None,
    business_phone_number: str = None,
    email_address: str = None,
    personal_email_address: str = None,
    business_email_address: str = None,
    address: Dict = None,
    shipping_address: Dict = None,
    mailing_address: Dict = None,
    billing_address: Dict = None,
    attributes: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the properties of a profile. The ProfileId is required for updating a customer profile. When calling the UpdateProfile API, specifying an empty string value means that any existing value will be removed. Not specifying a string value means that any value already there will be kept.

    Args:
        domain_name(str): The unique name of the domain.
        profile_id(str): The unique identifier of a customer profile.
        additional_information(str, optional): Any additional information relevant to the customer’s profile. Defaults to None.
        account_number(str, optional): A unique account number that you have given to the customer. Defaults to None.
        party_type(str, optional): The type of profile used to describe the customer. Defaults to None.
        business_name(str, optional): The name of the customer’s business. Defaults to None.
        first_name(str, optional): The customer’s first name. Defaults to None.
        middle_name(str, optional): The customer’s middle name. Defaults to None.
        last_name(str, optional): The customer’s last name. Defaults to None.
        birth_date(str, optional): The customer’s birth date. . Defaults to None.
        gender(str, optional): The gender with which the customer identifies. . Defaults to None.
        phone_number(str, optional): The customer’s phone number, which has not been specified as a mobile, home, or business number. . Defaults to None.
        mobile_phone_number(str, optional): The customer’s mobile phone number. Defaults to None.
        home_phone_number(str, optional): The customer’s home phone number. Defaults to None.
        business_phone_number(str, optional): The customer’s business phone number. Defaults to None.
        email_address(str, optional): The customer’s email address, which has not been specified as a personal or business address. . Defaults to None.
        personal_email_address(str, optional): The customer’s personal email address. Defaults to None.
        business_email_address(str, optional): The customer’s business email address. Defaults to None.
        address(Dict, optional): A generic address associated with the customer that is not mailing, shipping, or billing. Defaults to None.
        shipping_address(Dict, optional): The customer’s shipping address. Defaults to None.
        mailing_address(Dict, optional): The customer’s mailing address. Defaults to None.
        billing_address(Dict, optional): The customer’s billing address. Defaults to None.
        attributes(Dict, optional): A key value pair of attributes of a customer profile. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.profile.init.update(
                ctx, domain_name=value, profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.profile.init.update domain_name=value, profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="update_profile",
        op_kwargs={
            "DomainName": domain_name,
            "ProfileId": profile_id,
            "AdditionalInformation": additional_information,
            "AccountNumber": account_number,
            "PartyType": party_type,
            "BusinessName": business_name,
            "FirstName": first_name,
            "MiddleName": middle_name,
            "LastName": last_name,
            "BirthDate": birth_date,
            "Gender": gender,
            "PhoneNumber": phone_number,
            "MobilePhoneNumber": mobile_phone_number,
            "HomePhoneNumber": home_phone_number,
            "BusinessPhoneNumber": business_phone_number,
            "EmailAddress": email_address,
            "PersonalEmailAddress": personal_email_address,
            "BusinessEmailAddress": business_email_address,
            "Address": address,
            "ShippingAddress": shipping_address,
            "MailingAddress": mailing_address,
            "BillingAddress": billing_address,
            "Attributes": attributes,
        },
    )
