"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, domain_name: str, uri: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes an integration from a specific domain.

    Args:
        domain_name(str): The unique name of the domain.
        uri(str): The URI of the S3 bucket or any other type of data source.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.integration.delete(
                ctx, domain_name=value, uri=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.integration.delete domain_name=value, uri=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="delete_integration",
        op_kwargs={"DomainName": domain_name, "Uri": uri},
    )


async def get(hub, ctx, domain_name: str, uri: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns an integration for a domain.

    Args:
        domain_name(str): The unique name of the domain.
        uri(str): The URI of the S3 bucket or any other type of data source.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.integration.get(
                ctx, domain_name=value, uri=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.integration.get domain_name=value, uri=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="get_integration",
        op_kwargs={"DomainName": domain_name, "Uri": uri},
    )


async def list_all(
    hub, ctx, domain_name: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the integrations in your domain.

    Args:
        domain_name(str): The unique name of the domain.
        next_token(str, optional): The pagination token from the previous ListIntegrations API call. Defaults to None.
        max_results(int, optional): The maximum number of objects returned per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.integration.list_all(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.integration.list_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="list_integrations",
        op_kwargs={
            "DomainName": domain_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def put(
    hub,
    ctx,
    domain_name: str,
    object_type_name: str,
    uri: str = None,
    tags: Dict = None,
    flow_definition: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon Connect. An integration can belong to only one domain.

    Args:
        domain_name(str): The unique name of the domain.
        uri(str, optional): The URI of the S3 bucket or any other type of data source. Defaults to None.
        object_type_name(str): The name of the profile object type.
        tags(Dict, optional): The tags used to organize, track, or control access for this resource. Defaults to None.
        flow_definition(Dict, optional): The configuration that controls how Customer Profiles retrieves data from the source. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.integration.put(
                ctx, domain_name=value, object_type_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.integration.put domain_name=value, object_type_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="put_integration",
        op_kwargs={
            "DomainName": domain_name,
            "Uri": uri,
            "ObjectTypeName": object_type_name,
            "Tags": tags,
            "FlowDefinition": flow_definition,
        },
    )
