"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    domain_name: str,
    default_expiration_days: int,
    default_encryption_key: str = None,
    dead_letter_queue_url: str = None,
    matching: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a domain, which is a container for all customer data, such as customer profile attributes, object types, profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party integrations. Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be associated with one domain.

    Args:
        domain_name(str): The unique name of the domain.
        default_expiration_days(int): The default number of days until the data within the domain expires.
        default_encryption_key(str, optional): The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. Defaults to None.
        dead_letter_queue_url(str, optional): The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue. Defaults to None.
        matching(Dict, optional): The process of matching duplicate profiles. This process runs every Saturday at 12AM. Defaults to None.
        tags(Dict, optional): The tags used to organize, track, or control access for this resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.domain.create(
                ctx, domain_name=value, default_expiration_days=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.domain.create domain_name=value, default_expiration_days=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="create_domain",
        op_kwargs={
            "DomainName": domain_name,
            "DefaultExpirationDays": default_expiration_days,
            "DefaultEncryptionKey": default_encryption_key,
            "DeadLetterQueueUrl": dead_letter_queue_url,
            "Matching": matching,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specific domain and all of its customer data, such as customer profile attributes and their related objects.

    Args:
        domain_name(str): The unique name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.domain.delete(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.domain.delete domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="delete_domain",
        op_kwargs={"DomainName": domain_name},
    )


async def get(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific domain.

    Args:
        domain_name(str): The unique name of the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.domain.get(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.domain.get domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="get_domain",
        op_kwargs={"DomainName": domain_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all the domains for an AWS account that have been created.

    Args:
        next_token(str, optional): The pagination token from the previous ListDomain API call. Defaults to None.
        max_results(int, optional): The maximum number of objects returned per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.domain.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.domain.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="list_domains",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    domain_name: str,
    default_expiration_days: int = None,
    default_encryption_key: str = None,
    dead_letter_queue_url: str = None,
    matching: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key. After a domain is created, the name can’t be changed.

    Args:
        domain_name(str): The unique name of the domain.
        default_expiration_days(int, optional): The default number of days until the data within the domain expires. Defaults to None.
        default_encryption_key(str, optional): The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value. Defaults to None.
        dead_letter_queue_url(str, optional): The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue. Defaults to None.
        matching(Dict, optional): The process of matching duplicate profiles. This process runs every Saturday at 12AM. Defaults to None.
        tags(Dict, optional): The tags used to organize, track, or control access for this resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.customer_profile.domain.update(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.customer_profile.domain.update domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="customer-profiles",
        operation="update_domain",
        op_kwargs={
            "DomainName": domain_name,
            "DefaultExpirationDays": default_expiration_days,
            "DefaultEncryptionKey": default_encryption_key,
            "DeadLetterQueueUrl": dead_letter_queue_url,
            "Matching": matching,
            "Tags": tags,
        },
    )
