"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, report_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified report.

    Args:
        report_name(str, optional): The name of the report that you want to delete. The name must be unique, is case sensitive, and can't include spaces. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cur_report_definition.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cur_report_definition.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cur",
        operation="delete_report_definition",
        op_kwargs={"ReportName": report_name},
    )


async def describe_all(
    hub, ctx, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the AWS Cost and Usage reports available to this account.

    Args:
        max_results(int, optional): The maximum number of results that AWS returns for the operation. Defaults to None.
        next_token(str, optional): A generic string. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cur_report_definition.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cur_report_definition.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cur",
        operation="describe_report_definitions",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def modify(hub, ctx, report_name: str, report_definition: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Allows you to programatically update your report preferences.

    Args:
        report_name(str): The name of the report that you want to create. The name must be unique, is case sensitive, and can't include spaces. .
        report_definition(Dict): The definition of AWS Cost and Usage Report. You can specify the report name, time unit, report format, compression format, S3 bucket, additional artifacts, and schema elements in the definition. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cur_report_definition.modify(
                ctx, report_name=value, report_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cur_report_definition.modify report_name=value, report_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cur",
        operation="modify_report_definition",
        op_kwargs={"ReportName": report_name, "ReportDefinition": report_definition},
    )


async def put(hub, ctx, report_definition: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new report using the description that you provide.

    Args:
        report_definition(Dict): Represents the output of the PutReportDefinition operation. The content consists of the detailed metadata and data file information. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cur_report_definition.put(ctx, report_definition=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cur_report_definition.put report_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cur",
        operation="put_report_definition",
        op_kwargs={"ReportDefinition": report_definition},
    )
