"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    connection_token: str,
    contact_id: str = None,
    max_results: int = None,
    next_token: str = None,
    scan_direction: str = None,
    sort_order: str = None,
    start_position: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a transcript of the session, including details about any attachments. Note that ConnectionToken is used for invoking this API instead of ParticipantToken. The Amazon Connect Participant Service APIs do not use Signature Version 4 authentication.

    Args:
        contact_id(str, optional): The contactId from the current contact chain for which transcript is needed. Defaults to None.
        max_results(int, optional): The maximum number of results to return in the page. Default: 10. . Defaults to None.
        next_token(str, optional): The pagination token. Use the value returned previously in the next subsequent request to retrieve the next set of results. Defaults to None.
        scan_direction(str, optional): The direction from StartPosition from which to retrieve message. Default: BACKWARD when no StartPosition is provided, FORWARD with StartPosition. . Defaults to None.
        sort_order(str, optional): The sort order for the records. Default: DESCENDING. Defaults to None.
        start_position(Dict, optional): A filtering option for where to start. Defaults to None.
        connection_token(str): The authentication token associated with the participant's connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connectparticipant.transcript.get(ctx, connection_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connectparticipant.transcript.get connection_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connectparticipant",
        operation="get_transcript",
        op_kwargs={
            "ContactId": contact_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ScanDirection": scan_direction,
            "SortOrder": sort_order,
            "StartPosition": start_position,
            "ConnectionToken": connection_token,
        },
    )
