"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, type_: List, participant_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates the participant's connection. Note that ParticipantToken is used for invoking this API instead of ConnectionToken. The participant token is valid for the lifetime of the participant – until they are part of a contact. The response URL for WEBSOCKET Type has a connect expiry timeout of 100s. Clients must manually connect to the returned websocket URL and subscribe to the desired topic.  For chat, you need to publish the following on the established websocket connection:  {"topic":"aws/subscribe","content":{"topics":["aws/chat"]}}  Upon websocket URL expiry, as specified in the response ConnectionExpiry parameter, clients need to call this API again to obtain a new websocket URL and perform the same steps as before.  The Amazon Connect Participant Service APIs do not use Signature Version 4 authentication.

    Args:
        type_(List): Type of connection information required.
        participant_token(str): This is a header parameter. The Participant Token as obtained from StartChatContact API response.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connectparticipant.participant.connection.create(
                ctx, type_=value, participant_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connectparticipant.participant.connection.create type_=value, participant_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connectparticipant",
        operation="create_participant_connection",
        op_kwargs={"Type": type_, "ParticipantToken": participant_token},
    )
