"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub,
    ctx,
    content_type: str,
    content: str,
    connection_token: str,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sends a message. Note that ConnectionToken is used for invoking this API instead of ParticipantToken.  The Amazon Connect Participant Service APIs do not use Signature Version 4 authentication.

    Args:
        content_type(str): The type of the content. Supported types are text/plain.
        content(str): The content of the message.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        connection_token(str): The authentication token associated with the connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connectparticipant.message.send(
                ctx, content_type=value, content=value, connection_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connectparticipant.message.send content_type=value, content=value, connection_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connectparticipant",
        operation="send_message",
        op_kwargs={
            "ContentType": content_type,
            "Content": content,
            "ClientToken": client_token,
            "ConnectionToken": connection_token,
        },
    )
