"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub,
    ctx,
    content_type: str,
    connection_token: str,
    content: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sends an event. Note that ConnectionToken is used for invoking this API instead of ParticipantToken. The Amazon Connect Participant Service APIs do not use Signature Version 4 authentication.

    Args:
        content_type(str): The content type of the request. Supported types are:   application/vnd.amazonaws.connect.event.typing   application/vnd.amazonaws.connect.event.connection.acknowledged  .
        content(str, optional): The content of the event to be sent (for example, message text). This is not yet supported. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        connection_token(str): The authentication token associated with the participant's connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connectparticipant.event.send(
                ctx, content_type=value, connection_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connectparticipant.event.send content_type=value, connection_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connectparticipant",
        operation="send_event",
        op_kwargs={
            "ContentType": content_type,
            "Content": content,
            "ClientToken": client_token,
            "ConnectionToken": connection_token,
        },
    )
