"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def complete(
    hub, ctx, attachment_ids: List, client_token: str, connection_token: str
) -> Dict:
    r"""
    **Autogenerated function**

    Allows you to confirm that the attachment has been uploaded using the pre-signed URL provided in StartAttachmentUpload API.

    Args:
        attachment_ids(List): A list of unique identifiers for the attachments.
        client_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        connection_token(str): The authentication token associated with the participant's connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connectparticipant.attachment.upload.complete(
                ctx, attachment_ids=value, client_token=value, connection_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connectparticipant.attachment.upload.complete attachment_ids=value, client_token=value, connection_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connectparticipant",
        operation="complete_attachment_upload",
        op_kwargs={
            "AttachmentIds": attachment_ids,
            "ClientToken": client_token,
            "ConnectionToken": connection_token,
        },
    )


async def start(
    hub,
    ctx,
    content_type: str,
    attachment_size_in_bytes: int,
    attachment_name: str,
    client_token: str,
    connection_token: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a pre-signed Amazon S3 URL in response for uploading the file directly to S3.

    Args:
        content_type(str): Describes the MIME file type of the attachment. For a list of supported file types, see Feature specifications in the Amazon Connect Administrator Guide.
        attachment_size_in_bytes(int): The size of the attachment in bytes.
        attachment_name(str): A case-sensitive name of the attachment being uploaded.
        client_token(str): A unique case sensitive identifier to support idempotency of request.
        connection_token(str): The authentication token associated with the participant's connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connectparticipant.attachment.upload.start(
                ctx,
                content_type=value,
                attachment_size_in_bytes=value,
                attachment_name=value,
                client_token=value,
                connection_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connectparticipant.attachment.upload.start content_type=value, attachment_size_in_bytes=value, attachment_name=value, client_token=value, connection_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connectparticipant",
        operation="start_attachment_upload",
        op_kwargs={
            "ContentType": content_type,
            "AttachmentSizeInBytes": attachment_size_in_bytes,
            "AttachmentName": attachment_name,
            "ClientToken": client_token,
            "ConnectionToken": connection_token,
        },
    )
