"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, attachment_id: str, connection_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides a pre-signed URL for download of a completed attachment. This is an asynchronous API for use with active contacts.

    Args:
        attachment_id(str): A unique identifier for the attachment.
        connection_token(str): The authentication token associated with the participant's connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connectparticipant.attachment.init.get(
                ctx, attachment_id=value, connection_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connectparticipant.attachment.init.get attachment_id=value, connection_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connectparticipant",
        operation="get_attachment",
        op_kwargs={"AttachmentId": attachment_id, "ConnectionToken": connection_token},
    )
