"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    instance_id: str,
    contact_id: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of analysis segments for a real-time analysis session.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance.
        contact_id(str): The identifier of the contact.
        max_results(int, optional): The maximimum number of results to return per page. Defaults to None.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect_contact_lens_realtime_contact_analysis_segment.list_all(
                ctx, instance_id=value, contact_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect_contact_lens_realtime_contact_analysis_segment.list_all instance_id=value, contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect-contact-lens",
        operation="list_realtime_contact_analysis_segments",
        op_kwargs={
            "InstanceId": instance_id,
            "ContactId": contact_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
