"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def update_multiple(
    hub, ctx, security_profile_ids: List, user_id: str, instance_id: str
) -> None:
    r"""
    **Autogenerated function**

    Assigns the specified security profiles to the specified user.

    Args:
        security_profile_ids(List): The identifiers of the security profiles for the user.
        user_id(str): The identifier of the user account.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.security_profile.update_multiple(
                ctx, security_profile_ids=value, user_id=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.security_profile.update_multiple security_profile_ids=value, user_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_user_security_profiles",
        op_kwargs={
            "SecurityProfileIds": security_profile_ids,
            "UserId": user_id,
            "InstanceId": instance_id,
        },
    )
