"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    username: str,
    phone_config: Dict,
    security_profile_ids: List,
    routing_profile_id: str,
    instance_id: str,
    password: str = None,
    identity_info: Dict = None,
    directory_user_id: str = None,
    hierarchy_group_id: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a user account for the specified Amazon Connect instance. For information about how to create user accounts using the Amazon Connect console, see Add Users in the Amazon Connect Administrator Guide.

    Args:
        username(str): The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from [a-zA-Z0-9_-.\@]+.
        password(str, optional): The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password. Defaults to None.
        identity_info(Dict, optional): The information about the identity of the user. Defaults to None.
        phone_config(Dict): The phone settings for the user.
        directory_user_id(str, optional): The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned. Defaults to None.
        security_profile_ids(List): The identifier of the security profile for the user.
        routing_profile_id(str): The identifier of the routing profile for the user.
        hierarchy_group_id(str, optional): The identifier of the hierarchy group for the user. Defaults to None.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        tags(Dict, optional): One or more tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.init.create(
                ctx,
                username=value,
                phone_config=value,
                security_profile_ids=value,
                routing_profile_id=value,
                instance_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.init.create username=value, phone_config=value, security_profile_ids=value, routing_profile_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="create_user",
        op_kwargs={
            "Username": username,
            "Password": password,
            "IdentityInfo": identity_info,
            "PhoneConfig": phone_config,
            "DirectoryUserId": directory_user_id,
            "SecurityProfileIds": security_profile_ids,
            "RoutingProfileId": routing_profile_id,
            "HierarchyGroupId": hierarchy_group_id,
            "InstanceId": instance_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, instance_id: str, user_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a user account from the specified Amazon Connect instance. For information about what happens to a user's data when their account is deleted, see Delete Users from Your Amazon Connect Instance in the Amazon Connect Administrator Guide.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        user_id(str): The identifier of the user.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.init.delete(ctx, instance_id=value, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.init.delete instance_id=value, user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="delete_user",
        op_kwargs={"InstanceId": instance_id, "UserId": user_id},
    )


async def describe(hub, ctx, user_id: str, instance_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified user account. You can find the instance ID in the console (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.

    Args:
        user_id(str): The identifier of the user account.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.init.describe(
                ctx, user_id=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.init.describe user_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_user",
        op_kwargs={"UserId": user_id, "InstanceId": instance_id},
    )


async def list_all(
    hub, ctx, instance_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides summary information about the users for the specified Amazon Connect instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.init.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.init.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_users",
        op_kwargs={
            "InstanceId": instance_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
