"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, instance_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the hierarchy structure of the specified Amazon Connect instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.hierarchy.structure.describe(
                ctx, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.hierarchy.structure.describe instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_user_hierarchy_structure",
        op_kwargs={"InstanceId": instance_id},
    )


async def update(hub, ctx, hierarchy_structure: Dict, instance_id: str) -> None:
    r"""
    **Autogenerated function**

    Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.

    Args:
        hierarchy_structure(Dict): The hierarchy levels to update.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.hierarchy.structure.update(
                ctx, hierarchy_structure=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.hierarchy.structure.update hierarchy_structure=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_user_hierarchy_structure",
        op_kwargs={
            "HierarchyStructure": hierarchy_structure,
            "InstanceId": instance_id,
        },
    )
