"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(
    hub, ctx, user_id: str, instance_id: str, hierarchy_group_id: str = None
) -> None:
    r"""
    **Autogenerated function**

    Assigns the specified hierarchy group to the specified user.

    Args:
        hierarchy_group_id(str, optional): The identifier of the hierarchy group. Defaults to None.
        user_id(str): The identifier of the user account.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.hierarchy.init.update(
                ctx, user_id=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.hierarchy.init.update user_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_user_hierarchy",
        op_kwargs={
            "HierarchyGroupId": hierarchy_group_id,
            "UserId": user_id,
            "InstanceId": instance_id,
        },
    )
