"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(
    hub, ctx, name: str, hierarchy_group_id: str, instance_id: str
) -> None:
    r"""
    **Autogenerated function**

    Updates the name of the user hierarchy group.

    Args:
        name(str): The name of the hierarchy group. Must not be more than 100 characters.
        hierarchy_group_id(str): The identifier of the hierarchy group.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.hierarchy.group.name.update(
                ctx, name=value, hierarchy_group_id=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.hierarchy.group.name.update name=value, hierarchy_group_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_user_hierarchy_group_name",
        op_kwargs={
            "Name": name,
            "HierarchyGroupId": hierarchy_group_id,
            "InstanceId": instance_id,
        },
    )
