"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, name: str, instance_id: str, parent_group_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new user hierarchy group.

    Args:
        name(str): The name of the user hierarchy group. Must not be more than 100 characters.
        parent_group_id(str, optional): The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null. Defaults to None.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.hierarchy.group.init.create(
                ctx, name=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.hierarchy.group.init.create name=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="create_user_hierarchy_group",
        op_kwargs={
            "Name": name,
            "ParentGroupId": parent_group_id,
            "InstanceId": instance_id,
        },
    )


async def delete(hub, ctx, hierarchy_group_id: str, instance_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.

    Args:
        hierarchy_group_id(str): The identifier of the hierarchy group.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.hierarchy.group.init.delete(
                ctx, hierarchy_group_id=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.hierarchy.group.init.delete hierarchy_group_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="delete_user_hierarchy_group",
        op_kwargs={"HierarchyGroupId": hierarchy_group_id, "InstanceId": instance_id},
    )


async def describe(hub, ctx, hierarchy_group_id: str, instance_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified hierarchy group.

    Args:
        hierarchy_group_id(str): The identifier of the hierarchy group.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.hierarchy.group.init.describe(
                ctx, hierarchy_group_id=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.hierarchy.group.init.describe hierarchy_group_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_user_hierarchy_group",
        op_kwargs={"HierarchyGroupId": hierarchy_group_id, "InstanceId": instance_id},
    )


async def list_all(
    hub, ctx, instance_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides summary information about the hierarchy groups for the specified Amazon Connect instance. For more information about agent hierarchies, see Set Up Agent Hierarchies in the Amazon Connect Administrator Guide.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.user.hierarchy.group.init.list_all(
                ctx, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.user.hierarchy.group.init.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_user_hierarchy_groups",
        op_kwargs={
            "InstanceId": instance_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
