"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    instance_id: str,
    integration_association_id: str,
    use_case_type: str,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a use case for an AppIntegration association.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        integration_association_id(str): The identifier for the AppIntegration association.
        use_case_type(str): The type of use case to associate to the AppIntegration association. Each AppIntegration association can have only one of each use case type.
        tags(Dict, optional): One or more tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.use.case.create(
                ctx, instance_id=value, integration_association_id=value, use_case_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.use.case.create instance_id=value, integration_association_id=value, use_case_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="create_use_case",
        op_kwargs={
            "InstanceId": instance_id,
            "IntegrationAssociationId": integration_association_id,
            "UseCaseType": use_case_type,
            "Tags": tags,
        },
    )


async def delete(
    hub, ctx, instance_id: str, integration_association_id: str, use_case_id: str
) -> None:
    r"""
    **Autogenerated function**

    Deletes a use case from an AppIntegration association.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        integration_association_id(str): The identifier for the AppIntegration association.
        use_case_id(str): The identifier for the use case.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.use.case.delete(
                ctx, instance_id=value, integration_association_id=value, use_case_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.use.case.delete instance_id=value, integration_association_id=value, use_case_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="delete_use_case",
        op_kwargs={
            "InstanceId": instance_id,
            "IntegrationAssociationId": integration_association_id,
            "UseCaseId": use_case_id,
        },
    )


async def list_all(
    hub,
    ctx,
    instance_id: str,
    integration_association_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the use cases.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        integration_association_id(str): The identifier for the integration association.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.use.case.list_all(
                ctx, instance_id=value, integration_association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.use.case.list_all instance_id=value, integration_association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_use_cases",
        op_kwargs={
            "InstanceId": instance_id,
            "IntegrationAssociationId": integration_association_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
