"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(
    hub,
    ctx,
    instance_id: str,
    contact_flow_id: str,
    name: str,
    previous_contact_id: str = None,
    attributes: Dict = None,
    references: Dict = None,
    description: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Initiates a contact flow to start a new task.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        previous_contact_id(str, optional): The identifier of the previous chat, voice, or task contact. . Defaults to None.
        contact_flow_id(str): The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to Routing, Contact Flows. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose Show additional flow information. The ContactFlowId is the last part of the ARN, shown here in bold:  arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/846ec553-a005-41c0-8341-xxxxxxxxxxxx .
        attributes(Dict, optional): A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes. There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters. Defaults to None.
        name(str): The name of a task that is shown to an agent in the Contact Control Panel (CCP).
        references(Dict, optional): A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Defaults to None.
        description(str, optional): A description of the task that is shown to an agent in the Contact Control Panel (CCP). Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.task_contact.start(
                ctx, instance_id=value, contact_flow_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.task_contact.start instance_id=value, contact_flow_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="start_task_contact",
        op_kwargs={
            "InstanceId": instance_id,
            "PreviousContactId": previous_contact_id,
            "ContactFlowId": contact_flow_id,
            "Attributes": attributes,
            "Name": name,
            "References": references,
            "Description": description,
            "ClientToken": client_token,
        },
    )
