"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, instance_id: str, key: str) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Associates a security key to the instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        key(str): A valid security key in PEM format.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.security.key.associate(
                ctx, instance_id=value, key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.security.key.associate instance_id=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="associate_security_key",
        op_kwargs={"InstanceId": instance_id, "Key": key},
    )


async def disassociate(hub, ctx, instance_id: str, association_id: str) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Deletes the specified security key.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        association_id(str): The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.security.key.disassociate(
                ctx, instance_id=value, association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.security.key.disassociate instance_id=value, association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="disassociate_security_key",
        op_kwargs={"InstanceId": instance_id, "AssociationId": association_id},
    )


async def list_all(
    hub, ctx, instance_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Returns a paginated list of all security keys associated with the instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.security.key.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.security.key.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_security_keys",
        op_kwargs={
            "InstanceId": instance_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
