"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, instance_id: str, routing_profile_id: str, queue_configs: List
) -> None:
    r"""
    **Autogenerated function**

    Associates a set of queues with a routing profile.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        routing_profile_id(str): The identifier of the routing profile.
        queue_configs(List): The queues to associate with this routing profile.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.routing_profile.queue.associate(
                ctx, instance_id=value, routing_profile_id=value, queue_configs=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.routing_profile.queue.associate instance_id=value, routing_profile_id=value, queue_configs=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="associate_routing_profile_queues",
        op_kwargs={
            "InstanceId": instance_id,
            "RoutingProfileId": routing_profile_id,
            "QueueConfigs": queue_configs,
        },
    )


async def disassociate(
    hub, ctx, instance_id: str, routing_profile_id: str, queue_references: List
) -> None:
    r"""
    **Autogenerated function**

    Disassociates a set of queues from a routing profile.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        routing_profile_id(str): The identifier of the routing profile.
        queue_references(List): The queues to disassociate from this routing profile.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.routing_profile.queue.disassociate(
                ctx, instance_id=value, routing_profile_id=value, queue_references=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.routing_profile.queue.disassociate instance_id=value, routing_profile_id=value, queue_references=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="disassociate_routing_profile_queues",
        op_kwargs={
            "InstanceId": instance_id,
            "RoutingProfileId": routing_profile_id,
            "QueueReferences": queue_references,
        },
    )


async def list_all(
    hub,
    ctx,
    instance_id: str,
    routing_profile_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the queues associated with a routing profile.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        routing_profile_id(str): The identifier of the routing profile.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.routing_profile.queue.list_all(
                ctx, instance_id=value, routing_profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.routing_profile.queue.list_all instance_id=value, routing_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_routing_profile_queues",
        op_kwargs={
            "InstanceId": instance_id,
            "RoutingProfileId": routing_profile_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update_multiple(
    hub, ctx, instance_id: str, routing_profile_id: str, queue_configs: List
) -> None:
    r"""
    **Autogenerated function**

    Updates the properties associated with a set of queues for a routing profile.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        routing_profile_id(str): The identifier of the routing profile.
        queue_configs(List): The queues to be updated for this routing profile. Queues must first be associated to the routing profile. You can do this using AssociateRoutingProfileQueues.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.routing_profile.queue.update_multiple(
                ctx, instance_id=value, routing_profile_id=value, queue_configs=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.routing_profile.queue.update_multiple instance_id=value, routing_profile_id=value, queue_configs=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_routing_profile_queues",
        op_kwargs={
            "InstanceId": instance_id,
            "RoutingProfileId": routing_profile_id,
            "QueueConfigs": queue_configs,
        },
    )
